// Transform internal error to proper external format
//TODO: the error message string should be from a backend api result instead of from fmErroCode file
var fmErrorCodes = require('./fmErrorCodes');

var transformInternalError = function(result){
  var errMsg = fmErrorCodes[result.code.toString()];

  switch (parseInt(result.code)) {
    case 11204: //11204 is an error code that means invalid authentication. It's used by CWPC for XML as a catch all error code for the following Draco errors which are security sensitive: kUserAccountDisabled, kPasswordExpired, kInvalidUserAccount, kInvalidPassword, kAccessDenied, kLoginRequired.
    case 210: //"User account is inactive",
    case 211: //"Password has expired",
    case 212: //"Invalid user account and/or password; please try again",
    case 213: //"User account and/or password does not exist",
    case 9: // "Insufficient privileges",
      return getError('Unauthorized', fmErrorCodes["212"], "212");
    break;

    case 952: //result.result === "Invalid FileMaker Data API token (*)",
      return getError('Unauthorized', errMsg, result.code);
    break;

    default:
      return getError('FMServiceError', result.message, result.code);
  }

};

var getError = function(type, message, errorCode){
  return {
    type: type ? type : 'FMServiceError',
    messages: [
        {
          "message":message ? message : '',
          "code": errorCode ? errorCode : ''
        }
      ]
  };
};

module.exports.transform = transformInternalError;
